package w83b.w83bOperacionesPaso.w83bCertificaciones;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bCertificacionesBean;
import w83b.w83bBeans.W83bPlantillasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesRTF;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaCertificacionesCertSindConvRtfAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HashMap mapaPar = new HashMap();
		HashMap plantillas=(HashMap)contexto.get("w83bPlantillasMap");
		W83bPlantillasBean plantilla=(W83bPlantillasBean)plantillas.get(W83bClsConstantes.CERTIFICADO_CENTRALES_SINDICALES_CONVENIO.toUpperCase());
		W83bCertificacionesBean certificacion=(W83bCertificacionesBean)contexto.get("resultadoCertificacion");
		W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
		HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,certificacion.getIdioma());
		StringBuffer  tituloDepEu = (StringBuffer)datosDelDep.get("tituloDepEu");
		StringBuffer  tituloDepEs = (StringBuffer)datosDelDep.get("tituloDepEs");
	    StringBuffer  tituloDelelegacionEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
		StringBuffer  tituloDelelegacionEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
		mapaPar.put("<<DEPCAS>>",tituloDepEs.toString());
	    mapaPar.put("<<DEPEUS>>",tituloDepEu.toString());
	    mapaPar.put("<<DELEGACION>>",tituloDelelegacionEs.toString());
	    mapaPar.put("<<DELEGACIONEUSK>>",tituloDelelegacionEu.toString());
	    mapaPar.put("<<PIE>>",usuario.getCalleListadosFormateada());
	    //FIN PIE
		
	    	String[] firmante = certificacion.getFirmante().split("_");
			
			
			mapaPar.put("<<RESPONSABLE>>",firmante[0]);
			mapaPar.put("<<CARGOCASTCORTO>>",certificacion.getCargodesc().toUpperCase());
			mapaPar.put("<<CARGOEUSKCORTO>>",certificacion.getCargodese().toUpperCase());
			
			mapaPar.put("<<LOCALID>>",certificacion.getDescLocalidadCast());
			
			W83bDateUtil dateUtil = new W83bDateUtil();
			
			List listaDia = W83bDateUtil.getInstance().separarDiaMesAnyo(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(certificacion.getFechaSolicitud(),certificacion.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_CASTELLANO);
			List listaDiaEusk = W83bDateUtil.getInstance().separarDiaMesAnyo(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(certificacion.getFechaSolicitud(),certificacion.getIdioma()),W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_EUSKARA);
			
			int miMesCas = Integer.parseInt((String)listaDia.get(1)) -1 ;
			int miMesEus = Integer.parseInt((String)listaDiaEusk.get(1)) -1;
			
			String mesCastellano = W83bDateUtil.getInstance().sabernombremesmin(miMesCas, W83bClsConstantes.CONSTANTE_CASTELLANO);
			String mesEuskera = W83bDateUtil.getInstance().sabernombremesmin(miMesEus, W83bClsConstantes.CONSTANTE_EUSKARA);
			
			mapaPar.put("<<FECSOLIC>>",listaDia.get(0)+" de " + mesCastellano + " de " + listaDia.get(2));
			mapaPar.put("<<FECSOLICEUSK>>",listaDiaEusk.get(0)+"(e)ko " + mesEuskera + "(a)ren " + listaDiaEusk.get(2) + "(e)(a)n");	
			
			listaDia = W83bDateUtil.getInstance().separarDiaMesAnyo(dateUtil.getLocaleStringFromDate(new Date(),W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_CASTELLANO);
			listaDiaEusk = W83bDateUtil.getInstance().separarDiaMesAnyo(dateUtil.getLocaleStringFromDate(new Date(),W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_EUSKARA);
			
			miMesCas = Integer.parseInt((String)listaDia.get(1)) -1 ;
			miMesEus = Integer.parseInt((String)listaDiaEusk.get(1)) -1;
			
			mesCastellano = W83bDateUtil.getInstance().sabernombremesmin(miMesCas, W83bClsConstantes.CONSTANTE_CASTELLANO);
			mesEuskera = W83bDateUtil.getInstance().sabernombremesmin(miMesEus, W83bClsConstantes.CONSTANTE_EUSKARA);
			
			mapaPar.put("<<FECCAS>>",listaDia.get(0)+" de " + mesCastellano + " de " + listaDia.get(2));
			mapaPar.put("<<FECUSK>>",listaDiaEusk.get(0)+"(e)ko " + mesEuskera + "(a)ren " + listaDiaEusk.get(2) + "(e)(a)n");			
			
			listaDia = W83bDateUtil.getInstance().separarDiaMesAnyo(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(certificacion.getFechaEleccionHasta(),certificacion.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_CASTELLANO);
			listaDiaEusk = W83bDateUtil.getInstance().separarDiaMesAnyo(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(certificacion.getFechaEleccionHasta(),certificacion.getIdioma()),W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_EUSKARA);
			
			miMesCas = Integer.parseInt((String)listaDia.get(1)) -1 ;
			miMesEus = Integer.parseInt((String)listaDiaEusk.get(1)) -1;
			
			mesCastellano = W83bDateUtil.getInstance().sabernombremesmin(miMesCas, W83bClsConstantes.CONSTANTE_CASTELLANO);
			mesEuskera = W83bDateUtil.getInstance().sabernombremesmin(miMesEus, W83bClsConstantes.CONSTANTE_EUSKARA);
			
			
			listaDia = W83bDateUtil.getInstance().separarDiaMesAnyo(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(certificacion.getFechaRegistroDefinitivo(),certificacion.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_CASTELLANO);
			listaDiaEusk = W83bDateUtil.getInstance().separarDiaMesAnyo(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(certificacion.getFechaRegistroDefinitivo(),certificacion.getIdioma()),W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_EUSKARA);
			
			miMesCas = Integer.parseInt((String)listaDia.get(1)) -1 ;
			miMesEus = Integer.parseInt((String)listaDiaEusk.get(1)) -1;
			
			mesCastellano = W83bDateUtil.getInstance().sabernombremesmin(miMesCas, W83bClsConstantes.CONSTANTE_CASTELLANO);
			mesEuskera = W83bDateUtil.getInstance().sabernombremesmin(miMesEus, W83bClsConstantes.CONSTANTE_EUSKARA);
			
			
			mapaPar.put("<<FECREG>>",listaDia.get(0)+" de " + mesCastellano + " de " + listaDia.get(2));
			mapaPar.put("<<FECREGEUSK>>",listaDiaEusk.get(0)+"(e)ko " + mesEuskera + "(a)ren " + listaDiaEusk.get(2) + "(e)ra");
			
			//RESULTADO
			contexto.get("w83bCertificacionesBean");
			listaDia = W83bDateUtil.getInstance().separarDiaMesAnyo(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(certificacion.getFechaResultado(),certificacion.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_CASTELLANO);
			listaDiaEusk = W83bDateUtil.getInstance().separarDiaMesAnyo(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(certificacion.getFechaResultado(),certificacion.getIdioma()),W83bClsConstantes.CONSTANTE_CASTELLANO),W83bClsConstantes.CONSTANTE_EUSKARA);
			
			miMesCas = Integer.parseInt((String)listaDia.get(1)) -1 ;
			miMesEus = Integer.parseInt((String)listaDiaEusk.get(1)) -1;
			
			mesCastellano = W83bDateUtil.getInstance().sabernombremesmin(miMesCas, W83bClsConstantes.CONSTANTE_CASTELLANO);
			mesEuskera = W83bDateUtil.getInstance().sabernombremesmin(miMesEus, W83bClsConstantes.CONSTANTE_EUSKARA);
			
			
			mapaPar.put("<<FECRESULT>>",listaDia.get(0)+" de " + mesCastellano + " de " + listaDia.get(2));
			mapaPar.put("<<FECRESULTEUSK>>",listaDiaEusk.get(0)+"(e)ko " + mesEuskera + "(a)ren " + listaDiaEusk.get(2) + "(e)ra");
			
			SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
			listaDia = W83bDateUtil.getInstance().separarDiaMesAnyo(sdf.format(new Date()),W83bClsConstantes.CONSTANTE_CASTELLANO);
			miMesCas = Integer.parseInt((String)listaDia.get(1)) -1 ;			
			mesCastellano = W83bDateUtil.getInstance().sabernombremesmin(miMesCas, W83bClsConstantes.CONSTANTE_CASTELLANO);
			mapaPar.put("<<FECHOYCAS>>",listaDia.get(0)+" de " + mesCastellano + " de " + listaDia.get(2));
			
			sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
			listaDiaEusk = W83bDateUtil.getInstance().separarDiaMesAnyo(sdf.format(new Date()),W83bClsConstantes.CONSTANTE_EUSKARA);
			miMesEus = Integer.parseInt((String)listaDiaEusk.get(1)) -1;
			mesEuskera = W83bDateUtil.getInstance().sabernombremesmin(miMesEus, W83bClsConstantes.CONSTANTE_EUSKARA);
			mapaPar.put("<<FECHOYEUSK>>",listaDiaEusk.get(0)+"(e)ko " + mesEuskera + "(a)ren " + listaDiaEusk.get(2)+"(e)(a)n");
			
			
			
			LinkedHashMap listaConvenios = (LinkedHashMap)certificacion.getListaConvenios();
			int ultimoContadorConvenios = listaConvenios.size();
			
			if(!listaConvenios.isEmpty()){
				Collection c = listaConvenios.values();
				Iterator itrConvenios = c.iterator();
				
				StringBuffer tabla= new StringBuffer(5000);
				int contador = 0;
				while(itrConvenios.hasNext()&&tabla.length()<2500000){
					contador++;
					
					
					W83bCertificacionesBean miCertificacion =(W83bCertificacionesBean)itrConvenios.next();
					
					tabla.append("{\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid4657642\\\\charrsid4657642 "+contador+".- "+miCertificacion.getConvenio().toUpperCase()+"}{\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid14778100  (convenio "+miCertificacion.getCodConvenio()+")}{\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0\\\\b\\\\f1\\\\fs22\\\\insrsid4657642\\\\charrsid4657642\\\\par\\\\par \\\\ltrrow}");
					
					
					//1 Fila
					tabla.append("\\\\trowd \\\\irow0\\\\irowband0\\\\ltrrow\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20"); 
					tabla.append("\\\\clbrdrl\\\\brdrs\\\\brdrw20 \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx3308\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalb\\\\clbrdrt");
					tabla.append("\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalb\\\\clbrdrt");
					tabla.append("\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw20 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\pard \\\\ltrpar");
					tabla.append("\\\\qr \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\b\\\\ai\\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 \\\\~\\\\cell }\\\\pard \\\\ltrpar");
					tabla.append("\\\\qc \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\b\\\\ai\\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 \\\\'c1lava\\\\cell \\\\~\\\\cell }\\\\pard \\\\ltrpar");
					tabla.append("\\\\qc \\\\li0\\\\ri-70\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin-70\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\b\\\\ai\\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 Bizkaia\\\\cell }\\\\pard \\\\ltrpar");
					tabla.append("\\\\qc \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\b\\\\ai\\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 \\\\~\\\\cell Gipuzkoa\\\\cell \\\\~\\\\cell C.A.P.V.\\\\cell \\\\~\\\\cell }\\\\pard \\\\ltrpar");
					tabla.append("\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0 {\\\\rtlch\\\\fcs1 \\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 \\\\trowd \\\\irow0\\\\irowband0\\\\ltrrow");
					
					//2 Fila
					tabla.append("\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrs\\\\brdrw20 \\\\clbrdrb");
					tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx3308\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalb\\\\clbrdrt");
					tabla.append("\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalb\\\\clbrdrt");
					tabla.append("\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw20 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\row \\\\ltrrow");
					tabla.append("}\\\\pard \\\\ltrpar\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\ai\\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 Central Sindical\\\\cell }\\\\pard \\\\ltrpar");
					tabla.append("\\\\qc \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\ai\\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 Deleg.\\\\cell %\\\\cell }\\\\pard \\\\ltrpar");
					tabla.append("\\\\qc \\\\li0\\\\ri-70\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin-70\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\ai\\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 Deleg.\\\\cell }\\\\pard \\\\ltrpar");
					tabla.append("\\\\qc \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\ai\\\\af1 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 %\\\\cell Deleg.\\\\cell %\\\\cell Deleg.\\\\cell %\\\\cell }\\\\pard \\\\ltrpar");
					tabla.append("\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0 {\\\\rtlch\\\\fcs1 \\\\af1 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs20\\\\insrsid4657642\\\\charrsid4657642 \\\\trowd \\\\irow1\\\\irowband1\\\\ltrrow");
					
								
					List listaSindicatos =miCertificacion.getListaSindicatos();
					
					int totalAlava = 0;
					int totalGuipuzkoa = 0;
					int totalVizkaya = 0;
					int totalCAPV = 0;
					
					String totalAlavaS = "";
					String totalGuipuzkoaS = "";
					String totalVizkayaS = "";
					String totalCAPVS = "";
					
					String porcentajeTotalAlava="";
					String porcentajeTotalGuipuzkoa="";
					String porcentajeTotalVizkaya="";
					String porcentajeTotalCAVP = "";
					
					
					
					if(!listaSindicatos.isEmpty() && listaSindicatos.size()>0){
					
						certificacion.setListaSindicatos(listaSindicatos);
						
						certificacion.setDelegadosAlava(miCertificacion.getDelegadosAlava());	
						certificacion.setDelegadosGuipuzcoa(miCertificacion.getDelegadosGuipuzcoa());
						certificacion.setDelegadosVizcaya(miCertificacion.getDelegadosVizcaya());
						
						if(StringUtils.isEmpty(certificacion.getDelegadosAlava())){certificacion.setDelegadosAlava("0");}
						if(StringUtils.isEmpty(certificacion.getDelegadosGuipuzcoa())){certificacion.setDelegadosGuipuzcoa("0");}
						if(StringUtils.isEmpty(certificacion.getDelegadosVizcaya())){certificacion.setDelegadosVizcaya("0");}
						
					
						String porcentaje,numDelAlavaS,numDelVizkayaS,numDelGuipuzkoaS,numDelTotal="";
						
						int numDelAlava,numDelVizkaya,numDelGuipuzkoa  = 0;
						
						
						if(StringUtils.isNotEmpty(certificacion.getDelegadosAlava())){
							totalAlava = Integer.parseInt(certificacion.getDelegadosAlava());
							if(StringUtils.isEmpty(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(certificacion.getTerritorio())|| W83bClsConstantes.CONSTANTE_ALAVA.equals(certificacion.getTerritorio())){
								totalAlavaS = Integer.toString(totalAlava);
							}
						}
						
						if(StringUtils.isNotEmpty(certificacion.getDelegadosGuipuzcoa())){
							totalGuipuzkoa = Integer.parseInt(certificacion.getDelegadosGuipuzcoa());
							if(StringUtils.isEmpty(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(certificacion.getTerritorio())){
								totalGuipuzkoaS = Integer.toString(totalGuipuzkoa);
							}
						}
						if(StringUtils.isNotEmpty(certificacion.getDelegadosVizcaya())){
							totalVizkaya = Integer.parseInt(certificacion.getDelegadosVizcaya());
							if(StringUtils.isEmpty(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_BIZKAIA.equals(certificacion.getTerritorio())){
								totalVizkayaS = Integer.toString(totalVizkaya);
							}
						}
						
						
						if("0".equals(totalAlavaS)){porcentajeTotalAlava="0,00%";}
						else if(!"".equals(totalAlavaS)){porcentajeTotalAlava="100,00%";}
						
						if("0".equals(totalGuipuzkoaS)){porcentajeTotalGuipuzkoa="0,00%";}
						else if(!"".equals(totalGuipuzkoaS)){porcentajeTotalGuipuzkoa="100,00%";}
						
						if("0".equals(totalVizkayaS)){porcentajeTotalVizkaya="0,00%";}
						else if(!"".equals(totalVizkayaS)){porcentajeTotalVizkaya="100,00%";}
						
						totalCAPV = totalAlava + totalGuipuzkoa + totalVizkaya;
						totalCAPVS = Integer.toString(totalCAPV);
						
						if("0".equals(totalCAPVS)){porcentajeTotalCAVP="0,00%";}
						else if(!"".equals(totalCAPVS)){porcentajeTotalCAVP="100,00%";}
						
						
						//listaSindicatos.remove(ultimaPosicion);
						
						Iterator itr = listaSindicatos.iterator();
						
						while(itr.hasNext()){
							
							W83bCertificacionesBean cert=(W83bCertificacionesBean)itr.next();
						
							numDelAlava = 0;
							numDelAlavaS = "";
							numDelVizkaya = 0;
							numDelVizkayaS = "";
							numDelGuipuzkoa = 0;
							numDelGuipuzkoaS = "";
							numDelTotal = "";
						
							if(StringUtils.isNotEmpty(cert.getDelegadosAlava())){
								numDelAlava = Integer.parseInt(cert.getDelegadosAlava());							
							}
							if(StringUtils.isNotEmpty(cert.getDelegadosGuipuzcoa())){
								numDelGuipuzkoa = Integer.parseInt(cert.getDelegadosGuipuzcoa());	
							}
							if(StringUtils.isNotEmpty(cert.getDelegadosVizcaya())){
								numDelVizkaya = Integer.parseInt(cert.getDelegadosVizcaya()); 
							}
							
							
							tabla.append("\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrs\\\\brdrw20 \\\\clbrdrb");
							tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
							tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx3308\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalb\\\\clbrdrt");
							tabla.append("\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
							tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalb\\\\clbrdrt");
							tabla.append("\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
							tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw20 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\row \\\\ltrrow");
							tabla.append("}\\\\trowd \\\\irow2\\\\irowband2\\\\ltrrow\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrnone \\\\clbrdrl");
							tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
							tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx3308\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalc\\\\clbrdrt\\\\brdrnone"); 
							tabla.append("\\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
							tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalc\\\\clbrdrt\\\\brdrnone"); 
							tabla.append("\\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
							tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw20 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\pard \\\\ltrpar");
							tabla.append("\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid10626794 "+cert.getSiglasSindicato()+"}");
							
							
							
							if(StringUtils.isEmpty(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_ALAVA.equals(certificacion.getTerritorio())){
								porcentaje="";
								if(numDelAlava !=0 && totalAlava!=0){
									DecimalFormatSymbols simbolos = new DecimalFormatSymbols();//NOPMD
									simbolos.setDecimalSeparator(',');
									DecimalFormat df = new DecimalFormat("#,##0.00%",simbolos);//NOPMD
									porcentaje=df.format(((float)numDelAlava)/(float)totalAlava);	
									//porcentaje=calculoPorcentaje(String.valueOf((Double.parseDouble(Integer.toString(numDelAlava))*100)/Double.parseDouble(Integer.toString(totalAlava))))+"%";
								}else{
									porcentaje="0,00%";
								}
								
								numDelAlavaS = Integer.toString(numDelAlava);
							}else{
								numDelAlavaS = "";
								porcentaje="";
						   }
							
							tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692\\\\charrsid4657642"); 
							tabla.append("\\\\cell }\\\\pard \\\\ltrpar\\\\qr \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0 {\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid10626794 "+numDelAlavaS+"}");							
							tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{");
							tabla.append("\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid10626794 "+porcentaje+"}");
						 
						
							if(StringUtils.isEmpty(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_BIZKAIA.equals(certificacion.getTerritorio())){
								porcentaje="";
							
								if(numDelVizkaya !=0 && totalVizkaya!=0){
									DecimalFormatSymbols simbolos = new DecimalFormatSymbols();//NOPMD
									simbolos.setDecimalSeparator(',');
									DecimalFormat df = new DecimalFormat("#,##0.00%",simbolos);//NOPMD
									porcentaje=df.format(((float)numDelVizkaya)/(float)totalVizkaya);
									//porcentaje=calculoPorcentaje(String.valueOf((Double.parseDouble(Integer.toString(numDelVizkaya))*100)/Double.parseDouble(Integer.toString(totalVizkaya))))+"%";
								}else{
									porcentaje="0,00%";
								}
								numDelVizkayaS = Integer.toString(numDelVizkaya);
							}else{
								
								numDelVizkayaS="";
								porcentaje="";
							}
						
							tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692 ");
							tabla.append("\\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid10626794 "+numDelVizkayaS+"} {\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 ");
							tabla.append("\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid10626794 "+porcentaje+"}");
							
						
						
							if(StringUtils.isEmpty(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(certificacion.getTerritorio()) || W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(certificacion.getTerritorio())){
								porcentaje="";
								if(numDelGuipuzkoa !=0 && totalGuipuzkoa!=0){
									DecimalFormatSymbols simbolos = new DecimalFormatSymbols();//NOPMD
									simbolos.setDecimalSeparator(',');
									DecimalFormat df = new DecimalFormat("#,##0.00%",simbolos);//NOPMD
									porcentaje=df.format(((float)numDelGuipuzkoa)/(float)totalGuipuzkoa);
									//porcentaje=calculoPorcentaje(String.valueOf((Double.parseDouble(Integer.toString(numDelGuipuzkoa))*100)/Double.parseDouble(Integer.toString(totalGuipuzkoa))))+"%";
								}else{
									porcentaje="0,00%";
								}
								numDelGuipuzkoaS = Integer.toString(numDelGuipuzkoa);
							}else{
								numDelGuipuzkoaS = "";
								porcentaje="";
							}
						
							
							
							tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid10626794 "+numDelGuipuzkoaS+"}{");
							tabla.append("\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid10626794 "+porcentaje+"}");
							
							
						
							//Para el total de la CAPV
							int sumaSindicato=numDelAlava+numDelVizkaya+ numDelGuipuzkoa;
							int suma=totalAlava + totalVizkaya+totalGuipuzkoa;
							if(suma!=0 && sumaSindicato!=0){
								DecimalFormatSymbols simbolos = new DecimalFormatSymbols();//NOPMD
								simbolos.setDecimalSeparator(',');
								DecimalFormat df = new DecimalFormat("#,##0.00%",simbolos);//NOPMD
								porcentaje=df.format(((float)sumaSindicato)/(float)suma);
								//porcentaje = calculoPorcentaje(String.valueOf((Double.parseDouble(Integer.toString(sumaSindicato))*100)/Double.parseDouble(Integer.toString(suma))))+"%";
								numDelTotal = Integer.toString(sumaSindicato);
							}else{
								numDelTotal = "0";
								porcentaje = "0,00%";
							}
							
						
							
							
							tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0"); 
							tabla.append("\\\\f1\\\\fs22\\\\insrsid10626794 "+numDelTotal+"}{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid10626794 "+porcentaje+"}{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell ");
							tabla.append("}\\\\pard \\\\ltrpar\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0 {\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692\\\\charrsid4657642 \\\\trowd \\\\irow2\\\\irowband2\\\\ltrrow");
							
						
					}
					
							
				}else{
					
					tabla.append("\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrs\\\\brdrw20 \\\\clbrdrb");
					tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx3308\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalb\\\\clbrdrt");
					tabla.append("\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalb\\\\clbrdrt");
					tabla.append("\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw20 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw20 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\row \\\\ltrrow");
					tabla.append("}\\\\trowd \\\\irow2\\\\irowband2\\\\ltrrow\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrnone \\\\clbrdrl");
					tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx3308\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalc\\\\clbrdrt\\\\brdrnone"); 
					tabla.append("\\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalc\\\\clbrdrt\\\\brdrnone"); 
					tabla.append("\\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
					tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw20 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\pard \\\\ltrpar");
					tabla.append("\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid10626794 }");
					tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid2693692\\\\charrsid4657642"); 
					tabla.append("\\\\cell }\\\\pard \\\\ltrpar\\\\qr \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0 {\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid10626794 }");							
					tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{");
					tabla.append("\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid10626794 }");
					tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid2693692 ");
					tabla.append("\\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid10626794 } {\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 ");
					tabla.append("\\\\b\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid10626794 }");
					tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid10626794 }{");
					tabla.append("\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid10626794 }");
					tabla.append("{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0"); 
					tabla.append("\\\\b\\\\f1\\\\fs22\\\\insrsid10626794 }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid10626794 }{\\\\rtlch\\\\fcs1 \\\\ab\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell ");
					tabla.append("}\\\\pard \\\\ltrpar\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0 {\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692\\\\charrsid4657642 \\\\trowd \\\\irow2\\\\irowband2\\\\ltrrow");
					
				}
				
				
				
				//4 Fila	
				tabla.append("\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrs\\\\brdrw10 \\\\clbrdrb");
				tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil"); 
				tabla.append("\\\\cellx3308\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr");
				tabla.append("\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalc");
				tabla.append("\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
				tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalc\\\\clbrdrt\\\\brdrnone \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalc\\\\clbrdrt\\\\brdrnone ");
				tabla.append("\\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw20 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\row \\\\ltrrow}\\\\trowd \\\\irow3\\\\irowband3\\\\lastrow \\\\ltrrow");
				tabla.append("\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrs\\\\brdrw10 \\\\clbrdrb");
				tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
				tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx3308\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalb\\\\clbrdrt");
				tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
				tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalb\\\\clbrdrt");
				tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
				tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\pard \\\\ltrpar");
				tabla.append("\\\\qr \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\pararsid7743554 {\\\\rtlch\\\\fcs1 \\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\i\\\\f1\\\\fs22\\\\insrsid2693692\\\\charrsid4657642 Total\\\\cell }\\\\pard \\\\ltrpar");
				tabla.append("\\\\qr \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0 {\\\\rtlch\\\\fcs1 \\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\i\\\\f1\\\\fs22\\\\insrsid3569575 "+totalAlavaS+"}{\\\\rtlch\\\\fcs1 \\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\i\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell "+porcentajeTotalAlava+"\\\\cell }{\\\\rtlch\\\\fcs1 ");
				tabla.append("\\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\i\\\\f1\\\\fs22\\\\insrsid3569575 "+totalVizkayaS+"}{\\\\rtlch\\\\fcs1 \\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\i\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell "+porcentajeTotalVizkaya+"\\\\cell }{\\\\rtlch\\\\fcs1 \\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\i\\\\f1\\\\fs22\\\\insrsid3569575 "+totalGuipuzkoaS+"}{\\\\rtlch\\\\fcs1 \\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0"); 
				tabla.append("\\\\i\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell "+porcentajeTotalGuipuzkoa+"\\\\cell }{\\\\rtlch\\\\fcs1 \\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\i\\\\f1\\\\fs22\\\\insrsid3569575 "+totalCAPVS+"}{\\\\rtlch\\\\fcs1 \\\\ai\\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\i\\\\f1\\\\fs22\\\\insrsid2693692 \\\\cell "+porcentajeTotalCAVP+"\\\\cell }\\\\pard \\\\ltrpar");
				tabla.append("\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\intbl\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0 {\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\f1\\\\fs22\\\\insrsid2693692\\\\charrsid4657642 \\\\trowd \\\\irow3\\\\irowband3\\\\lastrow \\\\ltrrow");
				
					
				//Fin tabla
				tabla.append("\\\\ts11\\\\trqc\\\\trgaph70\\\\trrh300\\\\trleft770\\\\trkeep\\\\trftsWidth3\\\\trwWidth9659\\\\trftsWidthB3\\\\trftsWidthA3\\\\trautofit1\\\\trpaddl70\\\\trpaddr70\\\\trpaddfl3\\\\trpaddft3\\\\trpaddfb3\\\\trpaddfr3\\\\tblind840\\\\tblindtype3 \\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrs\\\\brdrw10 \\\\clbrdrb");
				tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1668\\\\clshdrawnil \\\\cellx2438\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 ");
				tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx3308\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx4317\\\\clvertalb\\\\clbrdrt");
				tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth870\\\\clshdrawnil \\\\cellx5187\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10"); 
				tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx6196\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1154\\\\clshdrawnil \\\\cellx7350\\\\clvertalb\\\\clbrdrt");
				tabla.append("\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx8359\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10"); 
				tabla.append("\\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1061\\\\clshdrawnil \\\\cellx9420\\\\clvertalb\\\\clbrdrt\\\\brdrs\\\\brdrw10 \\\\clbrdrl\\\\brdrnone \\\\clbrdrb\\\\brdrs\\\\brdrw10 \\\\clbrdrr\\\\brdrs\\\\brdrw10 \\\\cltxlrtb\\\\clNoWrap\\\\clftsWidth3\\\\clwWidth1009\\\\clshdrawnil \\\\cellx10429\\\\row }\\\\pard \\\\ltrpar");
				tabla.append("\\\\ql \\\\li0\\\\ri0\\\\widctlpar\\\\wrapdefault\\\\aspalpha\\\\aspnum\\\\faauto\\\\adjustright\\\\rin0\\\\lin0\\\\itap0\\\\pararsid4657642 {\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid4657642\\\\charrsid4657642"); 
				tabla.append("\\\\par"); 
				tabla.append("\\\\par"); 
				tabla.append("\\\\par ");
				tabla.append("\\\\par }");
					
			
				//tabla.append("{\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0\\\\b\\\\f1\\\\fs22\\\\insrsid4657642\\\\charrsid4657642\\\\par\\\\par \\\\ltrrow}");
				
				if(contador<ultimoContadorConvenios){
					tabla.append("{\\\\rtlch\\\\fcs1 \\\\af1\\\\afs22 \\\\ltrch\\\\fcs0 \\\\b\\\\f1\\\\fs22\\\\insrsid15423775 \\\\page }");
				}
			}
			mapaPar.put("<<TABLA>>", tabla.toString());
			if(tabla.length()>=2500000){
				contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.noTantosConvenios");
				contexto.get("w83bCertificacionesBean");
				return mapping.findForward("ok");
				
			}	
		}
			
			
			
	StringBuffer buffer = W83bUtilidadesRTF.sustituirCadenaCaracteresRtf(plantilla.getFichero(), mapaPar);
		
	
    response.setContentType("application/msword");
    response.setContentLength(buffer.toString().getBytes().length);
    response.setHeader("Content-disposition","attachment;filename="+plantilla.getNombrePlantilla());
    response.getOutputStream().write(buffer.toString().getBytes());
    response.getOutputStream().flush();
	
    return null;
	}
	
}

